#include <stdarg.h>
#include <stdio.h>
#include "Debug.h"
#include "Externs.h"

#ifdef NDEBUG
   void MsgBox(char *str, ...)
   {
      char buf[1024];
      va_list list;
      va_start(list, str);
      vsprintf(buf, str, list);
      va_end(list);
      if (Cgraph.GetDD()) Cgraph.GetDD()->FlipToGDISurface();   
      MessageBox(NULL, buf, "Debug", MB_OK);
   }

   inline void DebugOut(char *str, ...)
   {
   }
#else
   void MsgBox(char *str, ...)
   {
      char buf[1024];
      va_list list;
      va_start(list, str);
      vsprintf(buf, str, list);
      va_end(list);
      if (Cgraph.GetDD()) Cgraph.GetDD()->FlipToGDISurface();   
      DebugOut(buf);
      MessageBox(NULL, buf, "Debug", MB_OK);
   }

   void DebugOut(char *str, ...)
   {
      char buf[1024];
      int i;
      va_list list;
      va_start(list, str);
      i=vsprintf(buf, str, list);
      va_end(list);
      buf[i]   = '\n';
      buf[i+1] = '\0';
      OutputDebugString(buf);
   }
#endif
